#---------------------------------------------------
# Dateiname: digitaluhr_fullscreen.pyw
# Digitaluhr Vollbild
#
# So einfach! Programmieren lernen mit Python
# mitp 2023
# Kapitel 6
#
# Michael Weigend
# 24.03. 2023
# -------------------------------------------------
from time import localtime
from tkinter import *                                       

MONAT = ['Januar', 'Februar', 'März', 'April',
         'Mai', 'Juni', 'Juli', 'August',
         'September', 'Oktober', 'November', 'Dezember']    

TEXT = '''Heute ist der {}. {} {}.
Es ist jetzt genau
{} Uhr {} Minuten und {} Sekunden.'''


def zeitansage():
        t = localtime()                                     
        zeitText = TEXT.format(t.tm_mday,
                               MONAT[t.tm_mon - 1],
                               t.tm_year,
                               t.tm_hour, t.tm_min, t.tm_sec)
        label.config(text=zeitText)                                     
        fenster.after(1000, zeitansage)

def beenden(event):
    fenster.destroy()
  
fenster = Tk()
fenster.attributes('-fullscreen', True)
fenster.bind('<Any-KeyPress>', beenden)

label=Label(master=fenster,bg='darkblue',
            font=("Courier", 50), fg="white")
label.pack(expand=True, fill=BOTH)
fenster.after(1000, zeitansage)
fenster.mainloop()
