#---------------------------------------------------
# Dateiname: reimen_gui.pyw
# Reimen mit Goethe
#
# So einfach! Programmieren lernen mit Python
# mitp 2023
# Kapitel 6
#
# Michael Weigend
# 24.03. 2023
# -------------------------------------------------
from tkinter import *
FARBE = '#369'

def findeReime():
    endung = eingabe.get()
    ergebnis = []
    for wort in wortmenge:
        if wort.endswith(endung):
            ergebnis.append(wort)
    text = ''
    for wort in set(ergebnis):
        text += wort + ' '
    ausgabe.config(text=text)
        

# Wortmenge erzeugen
f = open('faust.txt', encoding='utf-8')
buch = f.read()
f.close()
for satzzeichen in '(),.;:-!?\n':
    buch = buch.replace(satzzeichen, ' ')
wortliste = buch.split(' ')
wortmenge = set(wortliste)


# Widgets
fenster = Tk()
fenster.config(background=FARBE)
bild = PhotoImage(file='goethe_top.png')
label_top = Label(master=fenster, text='Dichten mit Goethe',
                  font=('Stencil', 40), fg='darkblue', bg=FARBE)
ausgabe = Label(master=fenster, width=45, height=8,
                wrap=500, justify=LEFT, anchor=NW,
                font=('Arial', 16), fg='white', bg=FARBE)
label_eingabe = Label(master=fenster, text='Endung: ',
                      font=('Arial', 16), fg='white', bg=FARBE)
eingabe = Entry(master=fenster, font=('Arial', 16), bd=5)
button = Button(master=fenster, text='Finde Reime',
                font=('Arial', 16), 
                command=findeReime)

# Layout
                
label_top.pack()
ausgabe.pack()
label_eingabe.pack(side=LEFT, padx=5)
eingabe.pack(side=LEFT, padx=5)
button.pack(side=LEFT, padx=5, pady=5)
fenster.mainloop()


                  




                    
