#---------------------------------------------------
# Dateiname: notizen.py
# Digitales Notizbuch
# So einfach! Programmieren lernen mit Python
# mitp 2023
# Kapitel 7
#
# Michael Weigend
# 24.03. 2023
# --------------------------------------------------
from tkinter import *
import pickle
DATEINAME = 'notizbuch.dat'

def laden():
    try:
         f = open(DATEINAME, 'rb')
         notizen = pickle.load(f)
         f.close()   
         return notizen
    except:
         return []
    

def speichern():
    text = entry.get()
    notizen.append(text)  
    f = open(DATEINAME, 'wb')
    pickle.dump(notizen, f)
    f.close()
    
def suchen():
    ausgabe= ''
    suchtext = entry.get()
    for notiz in notizen:
        if suchtext in notiz:
            ausgabe += notiz + '\n'
    label.config(text=ausgabe)

notizen = laden()
fenster = Tk()
label = Label(master=fenster, text='Meine Notizen',
                   width=40, height=6,fg="blue",
                   font=('arial', 11))
button1 = Button(master=fenster, width=10,
                     text='speichern', command=speichern)
button2 = Button(master=fenster, width=10,
                     text='suchen',  command=suchen)

entry = Entry(master=fenster, width=50)
label.pack()
entry.pack(padx=5, pady=5)
button1.pack()
button2.pack()
fenster.mainloop()
