#-----------------------------------
# Notizenverwaltung mit Zeitangaben und
# Möglichkeit zu löschen
# So einfach! Programmieren lernen mit Python
# mitp 2023
# Kapitel 7, Challenge 3
#
# Michael Weigend
# 24.03. 2023
# --------------------------------------------------

from tkinter import *
from time import asctime
import pickle
DATEINAME = 'notizbuch.dat'

def laden():
    try:
         f = open(DATEINAME, 'rb')
         notizen = pickle.load(f)
         f.close()   
         return notizen
    except:
         return []
    

def speichern():
    text = entry.get()
    notizen.append(asctime() + ': ' +text)  
    f = open(DATEINAME, 'wb')
    pickle.dump(notizen, f)
    f.close()
    
def suchen():
    ausgabe= ''
    suchtext = entry.get()
    for notiz in notizen:
        if suchtext in notiz:
            ausgabe += notiz + '\n'
    label.config(text=ausgabe)

def löschen():
    suchtext = entry.get()
    for notiz in notizen:
        if suchtext in notiz:
            notizen.remove(notiz)
    label.config(text='Notiz(en) gelöscht')

notizen = laden()
fenster = Tk()
bild_speichern = PhotoImage(master=fenster, file='speichern.png')
bild_suchen = PhotoImage(master=fenster, file='suchen.png')
bild_löschen = PhotoImage(master=fenster, file='loeschen.png')

label = Label(master=fenster, text='Meine Notizen',
                   width=40, height=6,fg="blue",
                   font=('arial', 11))
button_speichern = Button(master=fenster, 
                     image=bild_speichern,
                    command=speichern)
button_suchen = Button(master=fenster, 
                     image=bild_suchen,  command=suchen)
button_löschen = Button(master=fenster, 
                     image=bild_löschen, command=löschen)

entry = Entry(master=fenster, width=30)
label.pack()
entry.pack(padx=5, pady=5, side=LEFT)
button_speichern.pack(side=LEFT)
button_suchen.pack(side=LEFT)
button_löschen.pack(side=LEFT)
fenster.mainloop()
